const DONNEES = {
    google: {
        unites: 1,       
        totalWh: 0.3,
        containerId: 'rack-google',
        compteurId: 'compteur-google'
    },
    ia: {
        unites: 15,
        totalWh: 4.5,
        containerId: 'rack-ia',
        compteurId: 'compteur-ia'
    }
};

function genererGraphique(type) {
    const data = DONNEES[type];
    const container = document.getElementById(data.containerId);
    const compteurDisplay = document.getElementById(data.compteurId);

    container.innerHTML = '';
    compteurDisplay.innerHTML = '0.0 <span class="unit">Wh</span>';

    let blocsAjoutes = 0;
    
    const interval = setInterval(() => {
        
        if (blocsAjoutes >= data.unites) {
            clearInterval(interval);
            return;
        }

        let couleurStroke;

        if (blocsAjoutes < 3) {
            couleurStroke = "#198754";
        } 
        else if (blocsAjoutes < 8) {
            couleurStroke = "#ffc107";
        } 
        else {
            couleurStroke = "#dc3545";
        }

        const svgBloc = `
            <svg class="serveur-block" viewBox="0 0 250 45" xmlns="http://www.w3.org/2000/svg">
                        
                <rect x="1" y="1" width="248" height="43" rx="4" ry="4" 
                        fill="#343a40" 
                        stroke="${couleurStroke}" 
                        stroke-width="2"/>

                <line x1="20" y1="15" x2="230" y2="15" fill="none" stroke="#6c757d"/>
                <line x1="20" y1="22" x2="230" y2="22" fill="none" stroke="#6c757d"/>
                <line x1="20" y1="29" x2="230" y2="29" fill="none" stroke="#6c757d"/>

                <circle cx="15" cy="22" r="3" fill="${couleurStroke}">
                        <animate attributeName="opacity" values="1;0.3;1" dur="1s" repeatCount="indefinite" />
                </circle>

                <circle cx="235" cy="22" r="3" fill="#0dcaf0">
                        <animate attributeName="opacity" values="0.3;1;0.3" dur="0.2s" repeatCount="indefinite" />
                </circle>

            </svg>
        `;

        container.insertAdjacentHTML('beforeend', svgBloc);

        const valeurActuelle = ((blocsAjoutes + 1) / data.unites) * data.totalWh;
        compteurDisplay.innerHTML = valeurActuelle.toFixed(2) + ' <span class="unit">Wh</span>';

        blocsAjoutes++;

    }, 150);
}

function lancerComparaison() {
    genererGraphique('google');
    setTimeout(() => {
        genererGraphique('ia');
    }, 100);
}